<?php declare(strict_types = 1);

namespace Gallery\Model\Subscribers;

use Core\Model\Event\TTPreload;
use Core\Model\Helpers\Arrays;
use Core\Model\Helpers\Strings;
use Gallery\FrontModule\Model\Albums;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TTPreloadSubscriber implements EventSubscriberInterface
{
	protected Albums $albums;

	public function __construct(
		Albums $albums
	)
	{
		$this->albums = $albums;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'core.ttPreload' => 'preload',
		];
	}

	public function preload(TTPreload $event): void
	{
		$albums = [];

		foreach ($event->data as $k => $v) {
			if (is_array($v)) {
				if (Strings::contains(mb_strtolower((string) $k), 'gal') && Arrays::hasOnlyNumbers($v)) {
					$albums = array_merge($albums, $v);
				} else {
					foreach ($v as $k2 => $v2) {
						if (is_numeric($v2) && Strings::contains(mb_strtolower((string) $k2), 'gal')) {
							$albums[] = (int) $v2;
						}
					}
				}
			} elseif (is_numeric($v) && Strings::contains(mb_strtolower((string) $k), 'gal')) {
				$albums[] = (int) $v;
			}
		}

		if (!empty($albums)) {
			$this->albums->getAlbums($albums);
		}
	}
}
