<?php declare(strict_types = 1);

namespace Gallery\Console;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Exception;
use Gallery\Model\Cleaner;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

class AutoResize extends AbstractCommand
{
	/** @var Cleaner @inject */
	public Cleaner $cleaner;

	protected function configure(): void
	{
		$this->setName('gallery:auto-resize-images');
	}

	protected function executeSchemaCommand(
		InputInterface                $input,
		OutputInterface               $output,
		Doctrine\ORM\Tools\SchemaTool $schemaTool,
		array                         $metadatas,
		SymfonyStyle                  $ui,
	): int
	{
		ini_set('memory_limit', '4G');
		$output->writeln('Auto resize images');

		try {
			Debugger::dispatch();

			$this->cleaner->autoResizeGalleries();

			$output->writeLn('<info>[OK] - resized</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
