<?php declare(strict_types = 1);

namespace Gallery\Console;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Exception;
use Gallery\Model\Cleaner;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

class CheckFilesNotInImages extends AbstractCommand
{
	/** @var Cleaner @inject */
	public Cleaner $cleaner;

	protected function configure(): void
	{
		$this->setName('gallery:check-files-not-in-images')
			->addOption('delete', null, InputOption::VALUE_OPTIONAL, '', 'false');
	}

	protected function executeSchemaCommand(
		InputInterface                $input,
		OutputInterface               $output,
		Doctrine\ORM\Tools\SchemaTool $schemaTool,
		array                         $metadatas,
		SymfonyStyle                  $ui,
	): int
	{
		ini_set('memory_limit', '4G');
		$output->writeln('Check files not in images');

		try {
			Debugger::dispatch();

			$list = $this->cleaner->checkFilesNotInImages();

			foreach ($list as $row) {
				$output->writeln($row);
			}

			if ($list && $input->getOption('delete') === 'true') {
				$this->cleaner->removeImages($list);
			}

			$output->writeLn('<info>[OK] - checked</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
