<?php declare(strict_types = 1);

namespace Gallery\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\NonUniqueResultException;
use Exception;
use Gallery\Model\Entities\Album;

/**
 * @method Album|null getReference($id)
 * @method Album[]|null getAll()
 * @method Album|null get($id)
 */
class Albums extends BaseEntityService
{
	final public const CACHE_NAMESPACE = 'albums';

	protected $entityClass = Album::class;

	/**
	 * @param string|int|string[]|int[] $id
	 *
	 * @return Album|Album[]|null
	 * @throws NonUniqueResultException
	 */
	public function getPublishedById(string|int|array $id): Album|array|null
	{
		$albums = $this->getEr()->createQueryBuilder('a', 'a.id')
			->andWhere(is_array($id) ? 'a.id IN (:id)' : 'a.id = :id')->setParameter('id', $id)
			->andWhere('a.isPublished = 1')
			->getQuery();

		return is_array($id) ? $albums->getResult() : $albums->getOneOrNullResult();
	}

	public function getCount(): int { return $this->getEr()->count([]); }

	/**
	 * @return Album[]
	 */
	public function getAlbums(?int $limit = null, ?int $offset = null): array
	{
		$qb = $this->getEr()->createQueryBuilder('a')->orderBy('a.id', 'DESC');

		if ($limit !== null) {
			$qb->setMaxResults($limit);
		}
		if ($offset !== null) {
			$qb->setFirstResult($offset);
		}

		return $qb->getQuery()->getResult();
	}

	public function getAlbum(int|string $id): ?Album
	{
		return $this->getEr()->find($id);
		//		$key = self::CACHE_NAMESPACE . '/' . $id;
		//
		//		return $this->getCache()->load($key, function(&$dep) use ($key, $id) {
		//			$dep = [Cache::Tags => [self::CACHE_NAMESPACE, $key]];
		//
		//			$album->getImages();
		//
		//			return $album;
		//		});
	}

	/**
	 * @throws Exception
	 */
	public function deleteAlbum(int|string $id): bool
	{
		if ($album = $this->getEr()->find($id)) {
			/** @var Album $album */

			if ($album->getImagesCount() !== 0) {
				throw new Exception('gallery.album.cannotDeleteContainsImages');
			}

			$this->em->remove($album);
			$this->em->flush();

			return true;
		}

		return false;
	}
}
