<?php declare(strict_types = 1);

namespace Gallery\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Images\ImageHelper;
use Nette\Utils\FileSystem;

class Cleaner
{
	public function __construct(
		protected Albums                 $albums,
		protected Images                 $images,
		protected EntityManagerDecorator $em,
	)
	{
	}

	public function autoResizeGalleries(): void
	{
		foreach ($this->images->getEr()->createQueryBuilder('i')
			         ->select('i.id, i.filename, i.path')->getQuery()->getScalarResult() as $row) {
			$path = WWW_DIR . $row['path'] . DS . $row['filename'];
			ImageHelper::autoResize($path);
		}
	}

	public function checkNotFoundImages(): array
	{
		$arr = [];

		foreach ($this->images->getEr()->createQueryBuilder('i')
			         ->select('i.id, i.filename, i.path')->getQuery()->getScalarResult() as $row) {
			$path = WWW_DIR . $row['path'] . DS . $row['filename'];
			if (!file_exists($path))
				$arr[$row['id']] = str_pad((string) $row['id'], 6, '0', STR_PAD_LEFT) . ' | ' . $path;
		}

		file_put_contents(LOG_DIR . DS . '_gallery_notFoundImagesFromGallery.log', implode("\r", $arr));
		file_put_contents(LOG_DIR . DS . '_gallery_notFoundImagesFromGallery_ids.log', implode(",", array_keys($arr)));

		return $arr;
	}

	public function checkFilesNotInImages(): array
	{
		$allImages = [];
		$arr       = [];

		foreach ($this->images->getEr()->createQueryBuilder('i')
			         ->select('i.id, i.filename, i.path')->getQuery()->getScalarResult() as $row) {
			$path = realpath(WWW_DIR . $row['path'] . DS . $row['filename']);
			if ($path)
				$allImages[$path] = $row['id'];
		}

		foreach (glob(UPLOADS_DIR . DS . 'products' . DS . '**' . DS . '*.*') as $file) {
			$realpath = realpath($file);
			if (!isset($allImages[$realpath]))
				$arr[] = $realpath;
		}

		file_put_contents(LOG_DIR . DS . '_gallery_filesNotInImages.log', implode("\r", $arr));

		return $arr;
	}

	public function removeImagesFromDB(array $ids): void
	{
		foreach ($ids as $id) {
			$image = $this->images->getReference($id);
			$this->em->remove($image);
		}

		$this->em->flush();
	}

	public function removeImages(array $list): void
	{
		foreach ($list as $row) {
			FileSystem::delete($row);
		}
	}
}
