<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Gallery\Model\Albums;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class AlbumListener implements EventSubscriberInterface
{
	use SmartObject;

	protected readonly Cache $cache;

	public function __construct(
		protected Storage    $cacheStorage,
		protected Translator $translator,
	)
	{
		$this->cache = new Cache($cacheStorage, Albums::CACHE_NAMESPACE);
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function onPreFlush(Album $album, PreFlushEventArgs $args): void
	{
		if ($album->getId()) {
			$this->cache->clean([
				Cache::Tags => ['album/' . $album->getId()],
			]);
		} else {
			$this->cache->clean([
				Cache::Tags => ['albums'],
			]);
		}
	}
}
