<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Gallery\Model\Albums;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ImageListener implements EventSubscriberInterface
{
	use SmartObject;

	protected readonly Cache $albumCache;

	public function __construct(
		protected Storage    $cacheStorage,
		protected Translator $translator,
	)
	{
		$this->albumCache = new Cache($cacheStorage, Albums::CACHE_NAMESPACE);
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function onPreFlush(Image $image, PreFlushEventArgs $args): void
	{
		if ($image->getAlbum()->getId()) {
			$this->albumCache->clean([
				Cache::Tags => ['album/' . $image->getAlbum()->getId()],
			]);
		} else {
			$this->albumCache->clean([
				Cache::Tags => ['albums'],
			]);
		}
	}
}
