<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'gallery__image_text')]
#[ORM\Entity]
#[ORM\EntityListeners([ImageTextListener::class])]
class ImageText
{
	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $source = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $title = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $alt = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $description = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $link = null;

	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Image::class, cascade: ['persist', 'remove'], inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'image_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	protected ?Image $image;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2)]
	protected string $lang;

	public function __construct(Image $image, string $lang)
	{
		$this->image = $image;
		$this->lang  = $lang;
	}

	public function __clone()
	{
		$this->image = null;
	}

	public function setImage(Image $image): void { $this->image = $image; }

	public function getImage(): Image { return $this->image; }

	public function getLang(): string { return $this->lang; }
}
