<?php declare(strict_types = 1);

namespace Gallery\DI;

use Core\DI\CompilerExtension;
use Nette;
use Nette\DI\Definitions\ServiceDefinition;

class GalleryExtension extends CompilerExtension
{
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Gallery' => 'Gallery\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		/** @var ServiceDefinition $def */
		$def = $builder->getDefinition('nette.latteFactory');
		$def->addSetup('addProvider', ['imagesService', $builder->getDefinition('gallery.front.images')]);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->methods["initialize"];

		$init->addBody('Gallery\Model\GalleryConfig::setParams($this->parameters[\'gallery\']);');
	}

}
