<?php declare(strict_types = 1);

namespace Gallery\FrontModule\Model\Dao;

use Core\Model\Providers\ISiteMapImage;

class Image implements ISiteMapImage
{
	/** @var bool|int */
	public         $isCover     = false;
	public int     $id;
	public ?string $title       = null;
	public ?string $description = null;
	public ?string $alt         = null;
	public ?string $source      = null;
	public ?string $file        = null;
	public ?string $link        = null;
	public int     $position;
	public ?array  $thumbCoords = [];
	public ?Album  $album       = null;
	public ?int    $albumId     = null;

	public function setFile(string $file): self
	{
		$this->file = str_replace('\\', '/', $file);

		return $this;
	}

	public function getFilePath(): ?string { return $this->file; }

	public function getCaption(): ?string { return $this->description; }

	public function getTitle(): ?string { return $this->title; }

	public function getGeoLocation(): string { return ''; }

	public function getLicense(): string { return ''; }

}
