<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Gallery\Model\Albums;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;

class AlbumListener implements EventSubscriberInterface
{
	use SmartObject;

	private Cache        $cache;
	protected Translator $translator;

	public function __construct(IStorage $cacheStorage, Translator $translator)
	{
		$this->cache      = new Cache($cacheStorage, Albums::CACHE_NAMESPACE);
		$this->translator = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 */
	public function onPreFlush(Album $album, PreFlushEventArgs $args): void
	{
		if ($album->getId()) {
			$this->cache->clean([
				Cache::TAGS => ['album/' . $album->getId()],
			]);
		} else {
			$this->cache->clean([
				Cache::TAGS => ['albums'],
			]);
		}
	}
}
