<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="gallery__album_text")
 * @ORM\Entity
 */
class AlbumText
{

	/**
	 * @var Album|null
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Album", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="album_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $album;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2)
	 */
	private string $lang;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $title = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $description = null;

	public function __construct(Album $album, string $lang)
	{
		$this->album = $album;
		$this->lang  = $lang;
	}

	public function __clone()
	{
		$this->album = null;
	}

	public function setAlbum(Album $album): void { $this->album = $album; }
	public function getAlbum(): Album { return $this->album; }
	public function getLang(): string { return $this->lang; }
}
