<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Gallery\Model\Albums;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;

class ImageListener implements EventSubscriberInterface
{
	use SmartObject;

	private Cache        $albumCache;
	protected Translator $translator;

	public function __construct(IStorage $cacheStorage, Translator $translator)
	{
		$this->albumCache = new Cache($cacheStorage, Albums::CACHE_NAMESPACE);
		$this->translator = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 */
	public function onPreFlush(Image $image, PreFlushEventArgs $args): void
	{
		if ($image->getAlbum()->getId()) {
			$this->albumCache->clean([
				Cache::TAGS => ['album/' . $image->getAlbum()->getId()],
			]);
		} else {
			$this->albumCache->clean([
				Cache::TAGS => ['albums'],
			]);
		}
	}
}
