<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Gallery\Model\Albums;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;

class ImageTextListener implements EventSubscriberInterface
{
	use SmartObject;

	private Cache        $albumCache;
	protected Translator $translator;

	public function __construct(IStorage $cacheStorage, Translator $translator)
	{
		$this->albumCache = new Cache($cacheStorage, Albums::CACHE_NAMESPACE);
		$this->translator = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 */
	public function onPreFlush(ImageText $imageText, PreFlushEventArgs $args): void
	{
		if ($imageText->getImage()->getAlbum()->getId()) {
			$this->albumCache->clean([
				Cache::TAGS => ['album/' . $imageText->getImage()->getAlbum()->getId()],
			]);
		} else {
			$this->albumCache->clean([
				Cache::TAGS => ['albums'],
			]);
		}
	}
}
