<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Neon\Neon;

final class Version20190117083842 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE gallery__image_text (lang VARCHAR(2) NOT NULL, image_id INT NOT NULL, source VARCHAR(255) DEFAULT NULL, title LONGTEXT DEFAULT NULL, description LONGTEXT DEFAULT NULL, INDEX IDX_43F6F4E53DA5256D (image_id), PRIMARY KEY(image_id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('ALTER TABLE gallery__image_text ADD CONSTRAINT FK_43F6F4E53DA5256D FOREIGN KEY (image_id) REFERENCES gallery__image (id) ON DELETE CASCADE');

		$this->addSql('CREATE TABLE gallery__album_text (lang VARCHAR(2) NOT NULL, album_id INT NOT NULL, title LONGTEXT DEFAULT NULL, description LONGTEXT DEFAULT NULL, INDEX IDX_D5C7A83B1137ABCF (album_id), PRIMARY KEY(album_id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('ALTER TABLE gallery__album_text ADD CONSTRAINT FK_D5C7A83B1137ABCF FOREIGN KEY (album_id) REFERENCES gallery__album (id) ON DELETE CASCADE');
	}

	public function postUp(Schema $schema)
	{
		$configFile  = @file_get_contents(APP_DIR . '/config/config.neon');
		$appConfig   = Neon::decode($configFile);
		$defaultLang = $appConfig['translation']['default'] ?? 'cs';

		$qb = $this->connection->createQueryBuilder();
		$qb->select('i.id, i.source, i.title, i.description')
			->from('gallery__image', 'i');

		$fks = $this->connection->fetchAll("
				SELECT *
					FROM information_schema.KEY_COLUMN_USAGE
					WHERE
  						REFERENCED_TABLE_NAME = 'gallery__album'
  						AND REFERENCED_COLUMN_NAME = 'id'
  						AND CONSTRAINT_SCHEMA = '{$this->connection->getDatabase()}'");

		$albumLangs = [];

		foreach ($fks as $fk) {
			$rows = $this->connection->fetchAll("SELECT * FROM {$fk['TABLE_NAME']} WHERE {$fk['COLUMN_NAME']} IS NOT NULL");

			foreach ($rows as $row) {
				$albumLangs[$row[$fk['COLUMN_NAME']]] = $row['lang'] ?? $defaultLang;
			}
		}

		$images = $this->connection->fetchAll("SELECT * FROM gallery__image");
		foreach ($images as $i) {
			$this->connection->insert('gallery__image_text', [
				'image_id'    => $i['id'],
				'lang'        => $albumLangs[$i['album_id']] ?? $defaultLang,
				'title'       => $i['title'],
				'description' => $i['description'],
				'source'      => $i['source'],
			]);
		}

		$albums = $this->connection->fetchAll("SELECT * FROM gallery__album");
		foreach ($albums as $a) {
			$this->connection->insert('gallery__album_text', [
				'album_id'    => $a['id'],
				'lang'        => $albumLangs[$a['id']] ?? $defaultLang,
				'title'       => $a['title'],
				'description' => $a['description'],
			]);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('DROP TABLE gallery__image_text');
		$this->addSql('DROP TABLE gallery__album_text');
	}
}
