<?php declare(strict_types = 1);

namespace GeneralServices\AdminModule\Presenters;

use GeneralServices\AdminModule\Components\IGroupFormFactory;
use GeneralServices\AdminModule\Components\IGroupsGridFactory;
use GeneralServices\AdminModule\Components\IServiceFormFactory;
use GeneralServices\AdminModule\Components\IServicesGridFactory;
use GeneralServices\Model\Entities\GeneralService;
use GeneralServices\Model\Entities\Group;
use Nette\Application\ForbiddenRequestException;
use Nette\Http\IResponse;


class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('generalServices.title.pages'));
		$this->setHeader('generalServices.title.generalServices', 'fa-file');
	}

	public function checkRequirements($element)
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'accessPages')) {
			throw new ForbiddenRequestException();
		}
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'generalServices.menu.addGroup',
				'link'  => 'Default:addGroup',
				'ico'   => 'plus',
			],
			[
				'title' => 'generalServices.menu.addService',
				'link'  => 'Default:addService',
				'ico'   => 'plus'
			]
		]]);
	}

	public function actionAddGroup()
	{
		$this->setTitle($this->translator->translate('generalServices.title.addGroup'));
		$this->setHeader('generalServices.title.addGroup', 'fa-file');
	}

	public function actionEditGroup($id)
	{
		$group = $this->em->getRepository(Group::class)->find($id);

		if (!$group)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('generalServices.title.editGroup'), $group->title);
		$this->setHeader('generalServices.title.editGroup', 'fa-file');
	}

	public function actionAddService()
	{
		$this->setTitle($this->translator->translate('generalServices.title.addGroup'));
		$this->setHeader('generalServices.title.addGeneralService', 'fa-file');
	}

	public function actionEditService($id)
	{
		$service = $this->em->getRepository(GeneralService::class)->find($id);

		if (!$service)
			$this->error(null, IResponse::S404_NOT_FOUND);
	}

	protected function createComponentServicesGrid(IServicesGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentGroupsGrid(IGroupsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentGroupForm(IGroupFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setGroup($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function () {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentServiceForm(IServiceFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setService($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function () {
			$this->redirect('default');
		};

		return $control;
	}

}