<?php declare(strict_types = 1);

namespace GeneralServices\DI;

use Core\DI\CompilerExtension;
use Core\Model\Templating\Macros\TemplateText;
use Nette;
use Pages\Model\Providers\ITemplateTextType;

class GeneralServicesExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['GeneralServices' => 'GeneralServices\*Module\Presenters\*Presenter']);

	}
}