<?php declare(strict_types = 1);

namespace GeneralServices\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

class Service
{
	use MagicAccessors {
		__get as MA__get;
	}

	/**
	 * @var int
	 */
	protected $id;

	/**
	 * @var string
	 */
	protected $title;

	/**
	 * @var bool
	 */
	protected $isPublished;

	/**
	 * @var int
	 */
	protected $position;

	/**
	 * @var string
	 */
	protected $introText;

	/**
	 * @var string
	 */
	protected $icon;

	/**
	 * @var Group[]
	 */
	protected $groups;

	/** @var array */
	protected $params;

	public function setId($id)
	{
		$this->id = $id;
		return $this;
	}

	public function setTitle($title)
	{
		$this->title = $title;
		return $this;
	}

	public function setIntroText($introText)
	{
		$this->introText = $introText;
		return $this;
	}

	public function setGroup(Group $group)
	{
		$this->groups = $group;
		return $this;
	}

	public function setParams($params) {
		$this->params = $params;
		return $this;
	}

	public function &__get($name)
	{
		return $this->params[$name] ?? $this->MA__get($name);
	}
}