<?php declare(strict_types = 1);

namespace GeneralServices\Model\Entities;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\TemplateReader\Entity\ITemplate;
use Core\Model\TemplateReader\Entity\TTemplate;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\Json;
use Nette\Utils\Validators;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="general_services__general_service")
 * @ORM\Entity
 */
class GeneralService implements ITemplate
{
	use Identifier;
	use MagicAccessors;
	use TTemplate;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", nullable=false)
	 */
	public $isPublished;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	public $position;

	/**
	 * @var string
	 * @ORM\Column(name="intro_text", type="text", nullable=true)
	 */
	public $introText;


	/**
	 * @var string
	 * @ORM\Column(name="icon", type="string", length=255, nullable=true)
	 */
	public $icon;


	/**
	 * @var Group[]
	 *
	 * @ORM\ManyToMany(targetEntity="Group", inversedBy="general_service")
	 * @ORM\JoinTable(name="general_services__group_general_services",
	 *  joinColumns={@ORM\JoinColumn(name="general_service_id", referencedColumnName="id")},
	 *  inverseJoinColumns={@ORM\JoinColumn(name="group_id", referencedColumnName="id")})
	 */
	public $groups;

	public function __construct($title = "")
	{
		$this->title = $title;
		$this->isPublished = 1;
		$this->texts = [];
	}

}