<?php declare(strict_types = 1);

namespace GeneralServices\Model\Navigation;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use GeneralServices\FrontModule\Model\GeneralServices as Services;
use GeneralServices\Model\Groups;
use GeneralServices\Model\TemplateTextType\GeneralServiceGroup;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;
use Nette\Utils\Strings;


class GeneralServices extends BaseNavigation implements INavigationItem
{

	protected $title = 'generalServices';
	protected $presenter = 'GeneralServices:Front:Default';
	protected $action = 'default';
	protected $presenterDetail = 'GeneralServices:Front:Default';
	protected $actionDetail = 'detail';

	/** @var Services */
	protected $generalServices;

	/** @var Groups */
	protected $groupsServices;

	/**
	 * @return BaseContainer
	 */
	public function __construct(Services $generalServices, Groups $groups)
	{
		$this->generalServices = $generalServices;
		$this->groupsServices = $groups;
	}

	public function getFormContainer()
	{
		$container = new BaseContainer();

		$servicesCategory = [];
		foreach ($this->groupsServices->getAll() as $category)
			$servicesCategory[$category->getId()] = $category->title;

		$container->addSelect('serviceCategory', 'generalServices.navigationForm.services', $servicesCategory)->setRequired();
		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;
		if ($this->presenterDetail == $presenter && $this->actionDetail == $action)
			return 2;

		return false;
	}

	public function routerIn($params, $urlParams = [])
	{

		$groupId = $params->componentParams['serviceCategory'];

		// listovani vsemi kategoriemi
		if ($groupId == 'all') {
			return [
				'presenter' => $this->presenter,
				'action'    => $this->action,
				'id'        => null,
			];
		}

		// detail
		if (isset($urlParams['path'])) {
			$params = explode('/', $urlParams['path']);
			if (count($params) == 3) {
				$id = explode('-', array_pop($params), 2);
				return [
					'presenter' => $this->presenterDetail,
					'action'    => $this->actionDetail,
					'id'        => $id,
				];
			}
		}

		// 1 kategorie
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => $groupId,
		];
	}

	public function routerOut($navigation, &$urlParams)
	{

		if (isset($urlParams['action']) && $urlParams['action'] == $this->actionDetail) {
			$service = $this->generalServices->get($urlParams['id']);
			return ($navigation->isHomepage ? '' : '/') . $navigation->alias . '/' . $service->getId() . '-' . Strings::webalize($service->title);
		}


		if ($navigation instanceof Navigation == false)
			return false;



		if (isset($navigation->componentParams['serviceCategory'])) {
			$group = $this->groupsServices->get($navigation->componentParams['serviceCategory']);
			if ($group)
				return ($navigation->isHomepage ? '' : '/') . $navigation->alias;
		}

	}
}