<?php declare(strict_types = 1);

namespace GeneralServices\AdminModule\Components;

use Core\Model\UI\BaseControl;
use GeneralServices\Model\GeneralServices;
use GeneralServices\Model\Groups;

class ServicesGrid extends BaseControl
{
	/** @var GeneralServices */
	protected $servicesService;

	public function __construct(GeneralServices $services)
	{
		$this->servicesService = $services;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$data = $this->servicesService->getEr()->createQueryBuilder('g');
		$grid = $this->createGrid($data);
		$grid->addColumnLink('title', 'default.title', 'Default:editService');
		$grid->addColumnStatus('isPublished', 'default.isPublished')->setAlign('center')
			->addOption(1, 'default.publish')->setIcon('check')->setClass('btn-success')->setShowTitle(false)->endOption()
			->addOption(0, 'default.unPublish')->setIcon('times')->setClass('btn-danger')->setShowTitle(false)->endOption()
			->onChange[] = [$this, 'gridPublishChange'];


		$grid->addAction('edit', '', 'Default:editService')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');

		$grid->getColumn('isPublished')->getElementPrototype('th')->class[] = 'w1';

		return $grid;
	}

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->servicesService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	public function gridPublishChange($id, $newStatus)
	{
		$presenter = $this->getPresenter();

		if ($this->servicesService->setPublish($id, $newStatus))
			$presenter->flashMessageSuccess('default.publishChanged');
		else
			$presenter->flashMessageDanger('default.publishChangeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->redrawItem($id);
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
}
