<?php

namespace GeneralServices\FrontModule\Model;

use GeneralServices\Model\Entities\GeneralService as Service;
use GeneralServices\FrontModule\Model\Dao as DaoServices;

class GeneralServices extends \Core\Model\Helpers\BaseEntityService
{
	protected $entityClass = Service::class;

	public function get($id)
	{
		$servicesRaw = $this->getEr()->createQueryBuilder('s')->addSelect('g')
			->where('s.isPublished')->andWhere(is_array($id) ? 's.id IN (:ids)' : 's.id = :ids')->setParameter('ids', $id)
			->innerJoin('s.group', 'g')->andWhere('g.isPublished = 1')
			->getQuery()
			->useResultCache(true, 120)
			->getResult();

		$services = $this->fillDao($servicesRaw);

		return is_array($id) ? $services : ($services[$id]) ?? null;
	}

	public function getPublishedByGroup($groupId)
	{
		/** @var Service[] */
		$servicesRaw = $this->getEr()->createQueryBuilder('s', 's.id')->addSelect('s')
			->addSelect('g')->where('s.isPublished = 1')
			->innerJoin('s.group', 'g')
			->andWhere(is_array($groupId) ? 'g.id IN (:groupId)' : 'g.id = :groupId')
			->andWhere('g.isPublished = 1')
			->setParameter('groupId', $groupId)
			->getQuery()
			->useResultCache(true, 120)
			->getResult();

		return $this->fillDao($servicesRaw);
	}

	/**
	 * @param Service[] $servicesRaw
	 */
	private function fillDao($servicesRaw)
	{
		$services = [];
		$groups = [];

		foreach ($servicesRaw as $s) {
			$service = (new DaoServices\Service())
				->setId($s->getId())
				->setTitle($s->title)
				->setIntroText($s->introText)
				->setParams($s->getTexts());

			//TODO Groups
			$services[$service->id] = $service;
		}

		return $services;
	}

}