<?php
/**
 * Created by PhpStorm.
 * User: Adam Ouhrabka
 * Date: 04.10.2018
 * Time: 11:39
 */

namespace GeneralServices\FrontModule\Model;


use Core\Model\Helpers\BaseEntityService;
use GeneralServices\Model\Entities\Group;
use GeneralServices\FrontModule\Model\Dao as DaoServices;


class Groups extends BaseEntityService
{
	protected $entityClass = Group::class;

	public function get($id)
	{

		bdump($id);
		$groupsRaw = $this->getEr()->createQueryBuilder('s')
			->andWhere(is_array($id) ? 's.id IN (:ids)' : 's.id = :ids')
			->setParameter('ids', $id)
			->getQuery()
			->useResultCache(true, 120)
			->getResult();

		bdump($groupsRaw);

		$groups = $this->fillDao($groupsRaw);


		return is_array($id) ? $groups : ($groups[$id]) ?? null;
	}


	public function getTree()
	{
		$query = $this->getEr()->createQueryBuilder('g')->orderBy('g.root, g.lft', 'ASC')
			->getQuery()->useResultCache(true, 120);
		return $this->fillDao($this->getEr()->buildTree($query->getArrayResult()));
	}

	/**
	 * @param array $groupsRaw
	 *
	 * @return DaoServices\Group[]
	 */
	public function fillDao($groupsRaw, $parent = null)
	{
		$groups = [];

		foreach ($groupsRaw as $group) {
			$g = (new DaoServices\Group())
				->setId($group['id'])
				->setTitle($group['title']);

			if ($parent)
				$g->setParent($parent);

			if ($group['__children']) {
				$g->setChilds($this->fillDao($group['__children']), $g);
			}

			$groups[$g->id] = $g;
		}

		return $groups;
	}
}