<?php declare(strict_types = 1);

namespace GeneralServices\FrontModule\Presenters;

use GeneralServices\FrontModule\Model\GeneralServices as Services;
use GeneralServices\FrontModule\Model\Groups;

final class DefaultPresenter extends BasePresenter
{
	/** @var Services */
	protected $generalServices;

	/** @var Groups */
	protected  $groups;

	public function __construct(Services $services, Groups $groups)
	{
		$this->generalServices = $services;
		$this->groups = $groups;
	}

	public function actionDefault($groupId)
	{
		if($groupId == null) {
			$this->template->services = $this->generalServices->getAll();
		} else {
			$this->template->services = $this->generalServices->getPublishedByGroup($groupId);
			$this->template->actualGroup = $this->groups->get($groupId);
		}

		$this->template->groups = $this->groups->getTree();
	}

	public function actionDetail($id)
	{

	}
}