<?php declare(strict_types = 1);

namespace GeneralServices\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @Gedmo\Tree(type="nested")
 * @ORM\Table(name="general_services__group")
 * @ORM\Entity(repositoryClass="Gedmo\Tree\Entity\Repository\NestedTreeRepository")
 */
class Group
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public $title;

	/**
	 * @var GeneralService
	 * @ORM\ManyToMany(targetEntity="GeneralService", mappedBy="groups")
	 */
	protected $services;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1})
	 */
	public $isPublished;

	/**
	 * @var Group[]
	 * @ORM\OneToMany(targetEntity="Group", mappedBy="parent")
	 * @ORM\OrderBy({"lft" = "ASC"})
	 */
	private $children;

	/**
	 * @var Group
	 * @Gedmo\TreeParent
	 * @ORM\ManyToOne(targetEntity="Group", inversedBy="childrens")
	 * @ORM\JoinColumn(name="parent_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $parent;

	/**
	 * @Gedmo\TreeLeft
	 * @ORM\Column(name="lft", type="integer")
	 */
	private $lft;

	/**
	 * @Gedmo\TreeLevel
	 * @ORM\Column(name="lvl", type="integer")
	 */
	private $lvl;

	/**
	 * @Gedmo\TreeRight
	 * @ORM\Column(name="rgt", type="integer")
	 */
	private $rgt;

	/**
	 * @Gedmo\TreeRoot
	 * @ORM\ManyToOne(targetEntity="Group")
	 * @ORM\JoinColumn(name="tree_root", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $root;

	public function __construct($title)
	{
		$this->title       = $title;
		$this->isPublished = 1;
		$this->services     = new ArrayCollection();
		$this->children    = new ArrayCollection();
	}

	/******
	 * === Group
	 */

	public function getRoot()
	{
		return $this->root;
	}

	public function setParent($parent = null)
	{
		$this->parent = $parent;
	}

	public function getParent()
	{
		return $this->parent;
	}

	public function getChildren() { return $this->children; }

	public function getLevel() { return $this->lvl; }
}