<?php declare(strict_types = 1);

namespace GeneralServices\Model;


use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Core\Model\Images\ImagePipe;
use Core\Model\Templating\Macros\TemplateText;
use GeneralServices\Model\Entities\GeneralService;
use Nette\Application\UI\ITemplateFactory;
use Nette\Utils\FileSystem;

class GeneralServices extends BaseEntityService
{

	use TPublish;

	protected $entityClass = GeneralService::class;

	/** @var ITemplateFactory */
	protected $templateFactory;

	/** @var ImagePipe */
	protected $imagePipe;

	public $templatesDir = TEMPLATES_DIR . '/Front/default/GeneralServices';

	protected $tmpDir = TMP_DIR . '/cache/latte/generalServices';

	public function __construct(ITemplateFactory $templateFactory, ImagePipe $imagePipe)
	{
		$this->templateFactory = $templateFactory;
		$this->imagePipe = $imagePipe;
	}

	public function getTemplates()
	{
		$templates = [];

		foreach (glob($this->templatesDir . '/*.latte') as $file)
			$templates[basename($file)] = pathinfo($file, PATHINFO_FILENAME);

		return $templates;
	}

	public function getTemplatePath($template)
	{
		return $this->templatesDir . '/' . $template;
	}

	public function getTemplateDir()
	{
		return TEMPLATES_DIR . '/Front/default/GeneralServices';
	}

	public function getPublishedByGroup($groupId)
	{
		return $this->getEr()->createQueryBuilder('s', 's.id')->where('s.isPublished = 1')
			->innerJoin('s.groups', 'g')
			->andWhere('g.id = :groupId')
			->andWhere('g.isPublished = 1')
			->setParameter('groupId', $groupId)
			->getQuery()->useResultCache(true, 120)
			->getResult();
	}

}