<?php declare(strict_types = 1);

namespace GeneralServices\Model\TemplateTextType;


use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use GeneralServices\Model\Entities\Group;
use GeneralServices\Model\GeneralServices;
use GeneralServices\Model\Groups;

class GeneralServiceGroup extends TemplateTextType implements ITemplateTextType
{

	/** @var string */
	protected $type = 'servicesByGroup';

	/** @var GeneralServices */
	protected $servicesService;

	/** @var Groups */
	protected $groupsService;

	public function __construct(GeneralServices $services, Groups $groups)
	{
		$this->servicesService = $services;
		$this->groupsService   = $groups;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$groups = ['' => ''];
		foreach ($this->groupsService->getEr()->findBy([], ['title' => 'ASC']) as $g) {
			$groups[$g->getId()] = $g->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $groups);
	}

	/**
	 * @param $params
	 *
	 * @return mixed
	 */
	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->servicesService->getPublishedByGroup($this->getDefault());
	}
}