<?php declare(strict_types = 1);

namespace Gls\Model;

use Nette\Http\Url;
use Override;

class Api extends Libs\Api
{
	#[Override]
	public function getTrackingUrl(string $parcelNumber, string $language = 'en'): string
	{
		$country = $this->config['country_code'];
		$url     = new Url($this->urls[$country]);

		return $url->getHostUrl() . "/tt_page.php?tt_value=$parcelNumber&lng=$language";
	}

	#[Override]
	public function getTrackingUrlXml(string $parcelNumber): string
	{
		$country = $this->config['country_code'];
		$url     = new Url($this->urls[$country]);

		return $url->getHostUrl() . "/tt_page_xml.php?pclid=$parcelNumber";
	}
}
