<?php declare(strict_types = 1);

namespace Gls\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ORM\Table(name: 'gls__parcel_number')]
class GlsParcelNumber
{
	#[ORM\Id]
	#[ORM\Column(type: 'string', nullable: false)]
	public string $numberPackage;

	#[ORM\ManyToOne(targetEntity: GlsOrder::class, inversedBy: 'associatedNumberPackages')]
	#[ORM\JoinColumn(name: 'parcel_order_id', referencedColumnName: 'order_id', nullable: false, onDelete: 'CASCADE')]
	protected GlsOrder $parcelOrder;

	public function __construct(string $numberPackage, GlsOrder $parcelOrder)
	{
		$this->numberPackage = $numberPackage;
		$this->parcelOrder   = $parcelOrder;
	}

	public function getNumberPackage(): string
	{
		return $this->numberPackage;
	}
}
