<?php declare(strict_types = 1);

namespace Gls\Model\Subscribers;

use Core\Model\Event\Event;
use EshopOrders\AdminModule\Model\Statuses;
use EshopOrders\Model\Entities\OrderStatus;
use Exception;
use Gls\Model\OrderApiService;
use Gls\Model\OrdersExported;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Tracy\Debugger;

class OrderSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected OrdersExported  $ordersExported,
		protected OrderApiService $orderApiService,
		protected Statuses        $statuses,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orders.checkCompleted' => 'checkCompleted',
		];
	}

	public function checkCompleted(Event $event): void
	{
		$orders = $this->ordersExported->getOrdersNotCompleted();

		$completed = [];
		foreach ($orders as $id => $go) {
			if ($this->orderApiService->checkCompleted($go)) {
				$completed[] = $id;
			}
		}

		if ($completed !== []) {
			try {
				$result = $this->statuses->changeStatus($completed, OrderStatus::STATUS_FINISHED);

				if ($result) {
					$this->ordersExported->markAsCompleted($completed);
				}
			} catch (Exception $e) {
				Debugger::log('GLS error - ' . $e->getMessage(), 'ordersCheckComplete');
				Debugger::log($e);
			}
		}

		$this->ordersExported->em->clear();
	}
}
