<?php declare(strict_types = 1);

namespace Gls\DI;

use Core\DI\CompilerExtension;
use Nette;

class GlsExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Gls' => 'Gls\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods["initialize"];

		$init->addBody('Gls\Model\GlsConfig::setParams($this->parameters[\'gls\']);');
	}
}
