<?php declare(strict_types = 1);

namespace Gls\Model;

use Nette\Http\Url;

class Api extends Libs\Api
{
	public function getTrackingUrl(string $parcelNumber, string $language = 'en'): string
	{
		$country = $this->config['country_code'];
		$url     = new Url($this->urls[$country]);

		return $url->getHostUrl() . "/tt_page.php?tt_value=$parcelNumber&lng=$language";
	}

	public function getTrackingUrlXml(string $parcelNumber): string
	{
		$country = $this->config['country_code'];
		$url     = new Url($this->urls[$country]);

		return $url->getHostUrl() . "/tt_page_xml.php?pclid=$parcelNumber";
	}
}
