<?php declare(strict_types = 1);

namespace Gls\Model;

class GlsApi
{
	public function getApi(): Api
	{
		return new Api([
			'username'         => GlsConfig::load('username'),
			'password'         => GlsConfig::load('password'),
			'client_number'    => GlsConfig::load('clientNumber'),
			'country_code'     => GlsConfig::load('countryCode', 'CZ'),
			'label_paper_size' => GlsConfig::load('format', 'A6'),
			'log_dir'          => TMP_DIR . '/../log/gls/',
		]);
	}
}
