<?php declare(strict_types = 1);

namespace Gls\Model\Subscribers;

use EshopOrders\FrontModule\Model\Dao\PaymentSpedition;
use EshopOrders\Model\PaymentSpeditions;
use Gls\Model\Entities\GlsOrder;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use Core\Model\Entities\EntityManagerDecorator;

class OrderFormSubscriber implements EventSubscriberInterface
{
	/** @var EntityManagerDecorator */
	protected EntityManagerDecorator $em;

	protected PaymentSpeditions $paymentSpeditions;

	public function __construct(EntityManagerDecorator $em, PaymentSpeditions $paymentSpeditions)
	{
		$this->em                = $em;
		$this->paymentSpeditions = $paymentSpeditions;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderBeforeSave' => ['orderBeforeSave', 100],
		];
	}

	public function orderBeforeSave(OrderEvent $event): void
	{
		$values = $event->formData;

		$spedition = $this->getSpeditions()[$values->speditions->{$values->speditionCountry}] ?? null;
		if ($spedition) {
			$entity = new GlsOrder($event->order);
			$this->em->persist($entity);
		}
	}

	/**
	 * @return PaymentSpedition[]
	 */
	protected function getSpeditions(): array
	{
		$result = [];
		foreach ($this->paymentSpeditions->getAllPublished() as $row) {
			if ($row->getSpedition()->getIdent() !== 'gls')
				continue;

			$result[$row->getSpedition()->getId()] = $row;
		}

		return $result;
	}
}
