<?php declare(strict_types = 1);

namespace Google\FrontModule\Components;

use Core\Model\UI\BaseControl;

class TagManager extends BaseControl
{
	/** @var string */
	protected $tagId;

	public function __construct($tagId)
	{
		$this->tagId = $tagId;
	}

	public function renderHeader()
	{
		if (!$this->tagId) {
			return '';
		}

		$this->template->tagId = $this->tagId;
		$this->template->render(__DIR__ . '/TagManagerHeader.latte');
	}

	public function renderBody()
	{
		if (!$this->tagId) {
			return '';
		}

		$this->template->tagId = $this->tagId;
		$this->template->render(__DIR__ . '/TagManagerBody.latte');
	}
}
