export class GoogleRecaptcha {
	constructor(Nette) {
		(function (document, Nette, grecaptcha) {
			let init = false;
			let gToken = null;

			Nette.recaptcha = function (grecaptcha) {
				const items = document.getElementsByClassName('g-recaptcha');
				const length = items.length;

				if (length > 0) {
					grecaptcha.ready(function () {
						for (let i = 0; i < length; i++) {
							let item = items[i];
							grecaptcha.render(item, {
								'callback': function (token) {
									gToken = token;
								}
							});
						}
						grecaptcha.execute().then(() => {
							const respons = document.getElementsByClassName('g-recaptcha-response');
							for (let i = 0; i < length; i++) {
								respons[i].value = gToken;
							}
						});

					});

					init = true;
				}
			};

			if (!init) {
				Nette.recaptcha(grecaptcha);
			}
		})(document, Nette, grecaptcha);
	}
}
