<?php declare(strict_types = 1);

namespace Google\Console;

use Exception;
use Google\Model\GoogleConfig;
use Google\Model\Reviews\ReviewsService;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'google:google-rating-download')]
class GoogleRatingDownload extends Command
{
	public function __construct(
		public ReviewsService $reviewsService,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('google:google-rating-download');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('Google rating download');

		try {
			foreach (GoogleConfig::loadArray('locationRatingList') ?: [] as $k => $v) {
				$this->reviewsService->downloadRating($k, $v['apiKey'], $v['locationId']);
			}

			$output->writeLn('<info>[OK] - downloaded</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
