<?php declare(strict_types = 1);

namespace Google\Console;

use Core\Model\Helpers\Caster;
use Exception;
use Google\Model\Reviews\ReviewsService;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'google:google-reviews-download')]
class GoogleReviewsDownload extends Command
{
	/** @var ReviewsService @inject */
	public ReviewsService $reviewsService;

	#[Override]
	protected function configure(): void
	{
		$this->setName('google:google-reviews-download')
			->addOption('apiKey', null, InputOption::VALUE_REQUIRED, '')
			->addOption('placeId', null, InputOption::VALUE_REQUIRED, '');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$apiKey  = Caster::toString($input->getOption('apiKey'));
		$placeId = Caster::toString($input->getOption('placeId'));

		$output->writeln('Google review download for place: ' . $apiKey);

		try {
			$this->reviewsService->downloadForPlace($apiKey, $placeId);

			$output->writeLn('<info>[OK] - downloaded</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
