<?php declare(strict_types = 1);

namespace Google\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;
use Override;

class GoogleExtension extends CompilerExtension
{

	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getmethods()['initialize'];

		$init->addBody('Google\Model\GoogleConfig::setParams($this->parameters[\'google\']);');
	}
}
