<?php declare(strict_types = 1);

namespace Google\FrontModule\Model;

use Nette\Caching\Cache;
use Nette\Caching\Storage;

class GoogleCache
{
	protected Cache $cache;

	public function __construct(
		protected Storage $storage
	)
	{
		$this->cache = new Cache($storage, 'google');
	}

	public function getCache(): Cache
	{
		return $this->cache;
	}

	public function getLocationRatingKey(string $key): string
	{
		return 'locationRating:' . $key;
	}

	public function clearLocationRating(string $key): void
	{
		$this->getCache()->remove($this->getLocationRatingKey($key));
	}
}
