<?php declare(strict_types = 1);

namespace Google\FrontModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Helpers\Caster;
use Nette\Caching\Cache;

class ReviewsService
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected GoogleCache            $googleCache,
	)
	{
	}

	/** @return array{rating: float, reviews_count: int}|null */
	public function getRating(string $key): ?array
	{
		/** @var array{rating: float, reviews_count: int}|null $result */
		$result = $this->googleCache->getCache()->load($this->googleCache->getLocationRatingKey($key), function(&$dep) use ($key) {
			$dep = [
				Cache::Expire => '1 week',
			];

			$data = $this->em->getConnection()->fetchAssociative("SELECT rating, reviews_count FROM google__location_rating WHERE id = ? LIMIT 1", [$key]);

			if ($data) {
				return [
					'rating'        => Caster::toFloat($data['rating']),
					'reviews_count' => Caster::toInt($data['reviews_count']),
				];
			}

			return null;
		});

		return $result;
	}
}
