<?php declare(strict_types = 1);

namespace Google\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ORM\Table(name: 'google__location_rating')]
class GoogleLocationRating
{
	#[ORM\Id]
    #[ORM\Column(type: 'string', length: 255)]
    public string $id;

	#[ORM\Column(type: 'datetime', nullable: true)]
    public ?string $updated = null;

	#[ORM\Column(type: 'string', length: 10, nullable: true)]
    public ?string $rating = null;

	#[ORM\Column(type: 'integer', nullable: false, options: ['default' => 0])]
    public int $reviewsCount = 0;
}
