<?php declare(strict_types = 1);

namespace Google\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'gooogle__google_review')]
#[ORM\Entity]
class GoogleReview
{
	use TIdUnsigned;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $placeId = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $authorName = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $authorUrl = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $profilePhotoUrl = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $rating = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $text = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $created = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $language = null;

	/**
	 * place_id + author_name + created
	 */
	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $reviewId = null;
}
