<?php declare(strict_types = 1);

namespace Google\Console;

use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Doctrine\ORM\Tools\SchemaTool;
use Google\Model\GoogleConfig;
use Google\Model\Reviews\ReviewsService;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class GoogleRatingDownload extends AbstractCommand
{
	public ReviewsService $reviewsService;

	public function __construct(
		ReviewsService $reviewsService,
		?string        $name = null
	)
	{
		parent::__construct($name);
		$this->reviewsService = $reviewsService;
	}

	protected function configure(): void
	{
		$this->setName('google:google-rating-download');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('Google rating download');

		try {
			foreach (GoogleConfig::load('locationRatingList') as $k => $v) {
				$this->reviewsService->downloadRating($k, $v['apiKey'], $v['locationId']);
			}

			$output->writeLn('<info>[OK] - downloaded</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
