<?php declare(strict_types = 1);

namespace Google\Console;

use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Doctrine\ORM\Tools\SchemaTool;
use Google\Model\Reviews\ReviewsService;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class GoogleReviewsDownload extends AbstractCommand
{
	/** @var ReviewsService|null @inject */
	public ?ReviewsService $reviewsService = null;

	protected function configure(): void
	{
		$this->setName('google:google-reviews-download')
			->addOption('apiKey', null, InputOption::VALUE_REQUIRED, '')
			->addOption('placeId', null, InputOption::VALUE_REQUIRED, '');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('Google review download for place: ' . $input->getOption('placeId'));

		try {
			if (!$this->reviewsService) {
				throw new \Exception('Service not found');
			}

			$this->reviewsService->downloadForPlace($input->getOption('apiKey'), $input->getOption('placeId'));

			$output->writeLn('<info>[OK] - downloaded</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
