<?php declare(strict_types = 1);

namespace Google\DI;

use Core\DI\CompilerExtension;
use Nette;

class GoogleExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('Google\Model\GoogleConfig::setParams(?);', [$builder->parameters['google']]);
	}
}
