<?php declare(strict_types = 1);

namespace Google\FrontModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Nette\Caching\Cache;

class ReviewsService
{
	protected EntityManagerDecorator $em;
	protected GoogleCache            $googleCache;

	public function __construct(
		EntityManagerDecorator $em,
		GoogleCache            $googleCache
	)
	{
		$this->em          = $em;
		$this->googleCache = $googleCache;
	}

	public function getRating(string $key): ?array
	{
		return $this->googleCache->getCache()->load($this->googleCache->getLocationRatingKey($key), function(&$dep) use ($key) {
			$dep = [
				Cache::EXPIRE => '1 week',
			];

			$data = $this->em->getConnection()->fetchAssociative("SELECT rating, reviews_count FROM google__location_rating WHERE id = ? LIMIT 1", [$key]);

			if ($data) {
				return [
					'rating'        => (float) $data['rating'],
					'reviews_count' => (int) $data['reviews_count'],
				];
			}

			return [];
		}) ?: null;
	}
}
