export class CartTrackingExtension {
	constructor(naja) {
		
		naja.addEventListener('success', (e) => {
			let el = document.activeElement;
			if (el.dataset.addToCartSubmit) {
				
				let pEl = el.closest('[data-add-to-cart-price-wrap]');
				let productId = parseInt(pEl.querySelector('[data-add-to-cart-id-input]').value);
				let quantity = parseInt(pEl.querySelector('[data-add-to-cart-quantity-input]').value);
				let price = pEl.querySelector('[data-price]').dataset.price;
				
				dataLayer.push({
					event: 'add_to_cart',
					value: (quantity * price), //cena * kvantita
					items: [{
							id: productId,
							google_business_vertical: 'retail'
					}]
				});
			}
		});
	}
}
