<?php declare(strict_types=1);

namespace Google\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Nette\Utils\Json;

class GtmRemarketing extends BaseControl
{
    /** @var array array of data to be converted to JSON in template and pushed to GTM dataLayer */
    protected $data;

    public function __construct()
    {
    }

    public function setData(array $data)
    {
        $this->data = $data;
    }

    public function render()
    {
        if (!$this->data) {
            return '';
        }

        $this->template->data = Json::encode($this->data);
        $this->template->render(__DIR__ . '/GtmRemarketing.latte');
    }

}
