<?php declare(strict_types=1);

namespace Google\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Nette\Security\User as SUser;

class GtmUserTracking extends BaseControl
{
	/** @var SUser */
	protected $sUser;

    public function __construct(SUser $user)
    {
		$this->sUser         = $user;
    }

    public function render()
    {
        if (!$this->sUser || !$this->sUser->isLoggedIn()) {
            return '';
        }

        $this->template->user = $this->sUser;
		$this->template->render(__DIR__ . '/GtmUserTracking.latte');
    }

}
